/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.mainhttp.impl.util;

import java.util.Objects;

public class ClaimPool<T> {
    private Claim top = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Claim claim(T value) {
        ClaimPool claimPool = this;
        synchronized (claimPool) {
            this.top = new Claim(value, this.top);
            return this.top;
        }
    }

    public T getTopmost() {
        Claim tp = this.top;
        return tp == null ? null : (T)tp.value;
    }

    public boolean isEmpty() {
        return this.top == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClaimPool{");
        Claim current = this.top;
        while (current != null) {
            sb.append(current.value).append(" -> ");
            current = current.prev;
        }
        return sb.append('}').toString();
    }

    public class Claim {
        private Claim prev;
        private Claim next;
        private final T value;
        private boolean active = true;

        private Claim(T value, Claim prev) {
            this.value = value;
            if (prev != null) {
                this.prev = prev;
                prev.next = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Claim claim = Objects.requireNonNullElse(this.prev, this);
            synchronized (claim) {
                Claim claim2 = this;
                synchronized (claim2) {
                    ClaimPool claimPool = Objects.requireNonNullElse(this.next, ClaimPool.this);
                    synchronized (claimPool) {
                        if (!this.active) {
                            throw new UnsupportedOperationException("Cannot release claim that is already released");
                        }
                        this.active = false;
                        if (this.prev != null) {
                            this.prev.next = this.next;
                        }
                        if (this.next != null) {
                            this.next.prev = this.prev;
                        }
                        if (ClaimPool.this.top == this) {
                            ClaimPool.this.top = this.prev;
                        }
                    }
                }
            }
        }
    }
}

